require( "quest/subway/convout.lua" );
combine_speech_tables();

--firstvisit = 0;
proceed_table = {west = 1, east = 1, cant_leave = 0};
local do_map_tutorial = false;

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "subwaymap" then
			coroutine.yield(RESUME.NOW); -- wait a frame
			actor:JumpToPoint(scene.MAP:GetZoneWalkToPoint());
			actor:FaceNow(DIR.S);
		else
			actor:JumpToNamedPoint("entrance");
			actor:FaceNow(DIR.S);
			actor:WalkTo("flo");
			wait_walkto();
			actor:FaceNow(DIR.S);
			
			actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		end
		
		game:Set("first_time_subway", 1);
		
		flo_click(actor);
	end;
	
	on_arrive = function(flo, flo2)
		flo:StartProc(flo_click);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function flo_click(flo)
	flo:SetMode(MODE.CUTSCENE);
	local module_progress = game:Get("module_progress");
	if proceed_table.cant_leave == 1 then 
		if module_progress == 1 then
			run_super_conversation(flo, "conv_subway1_intro");
		elseif module_progress == 2 then
			run_super_conversation(flo, "conv_subway2_intro");
		else
			run_super_conversation(flo, "quip_flo_general");
		end
	else
		if module_progress == 1 then
			run_super_conversation(flo, "conv_subway1_ready");
		elseif module_progress == 2 then
			run_super_conversation(flo, "conv_subway2_ready");
		else
			run_super_conversation(flo, "quip_flo_general");
		end
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end
	
function exit_subway(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkToXY(scene.EXIT:GetZoneWalkToPoint());
	wait_walkto();
	
	flo:WalkTo("exit");
	wait_walkto();
	if game:Get("cur_module") == 1 then
		goto_scene(flo, "m1_spendalot1");
	elseif game:Get("cur_module") == 2 then
		goto_scene(flo, "m2_sizzle1");
	else
		goto_scene(flo, "m3_pancake");
	end
end

exit_spec = 
{
	name = "EXIT";
	halo = "exit";
	
	command = function(actor)
		actor:SetPointAtCursor("cursor_arrow_n");
	end;
	
	on_click = function(flo, actor)
		flo:StartProc(exit_subway);
		
		return RESPONSE.IGNORE;
	end;
}

map_spec =
{
	name = "MAP";
	halo = "map";
	command = function(actor)
		actor:SetDepthValue(391);
	end;
	
	on_arrive = function(flo, actor)
		game:Set("subway_eastbound", 2);
		scene:ChainToSubScene("subwaymap");
	end;
}

function set_module_progress()
	local cur_module = game:Get("cur_module");
	local module_progress = game:Get("module_progress");
	
	if module_progress < 1 then
		module_progress = 1;
	elseif module_progress < 2 and cur_module > 1 then
		do_map_tutorial = true;
		module_progress = 2;
	elseif module_progress < 3 and cur_module > 2 then
		do_map_tutorial = true;
		module_progress = 3;
	end
	
	game:Set("module_progress", module_progress);
end

function gate_check(t)
	curmodule = game:Get("cur_module");
	progress = game:Get("module_progress");
	t.west = 1;
	t.east = 1;
	t.cant_leave = 0;
	
	------------------
	--MODULE 1--
	if curmodule == 1 then
		t.west = 0;
	
		if progress == 1 then
			if not quest_complete("wedding_dress") or not quest_complete("find_snookums") or not quest_complete("collect_butterflies1") then
				t.cant_leave = 1;
			end
		elseif progress == 2 then
		else
			if quest_complete("figure_out_clues") and not quest_complete("rings") then
				t.east = 0; -- can't go to module 2 or 3
			end
		end
	
	------------------
	--MODULE 2--
	elseif curmodule == 2 then
		if progress == 2 then
			if not quest_complete("cake") or not quest_complete("collect_butterflies2") then
				t.cant_leave = 1;
			end
			t.west = 0;
		elseif progress == 3 then	
			if quest_complete("figure_out_clues") and not quest_complete("rings") then
				t.east = 0; -- can't go to module 3
			end
			
			if quest_complete("find_bernie") and not quest_complete("figure_out_clues") then
				t.west = 0; -- can't go to module 1
			end
		end
	
	------------------
	--MODULE 3--
	elseif curmodule == 3 then
		t.east = 0;
		
		if not quest_complete("flowers") or (quest_complete("find_bernie") and not quest_complete("figure_out_clues")) then
			t.cant_leave = 1;
		end
	end;
end

function train_fade(flo, east)
	if ( east ) then
		scene.TRAIN_EAST:PlayAnim( "Exit" );
		wait_anim(scene.TRAIN_EAST);
	else
		scene.TRAIN_WEST:PlayAnim( "Exit" );
		wait_anim(scene.TRAIN_WEST);
	end

	scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
	scene:SetFadeSpeed(0.05);
	scene:SetMusicVolumeSpeed(0.05);
	
	wait_fade();
	
	local times_taken_subway = game:Get("num_times_taken_subway");
	
	if times_taken_subway < 1 then
		times_taken_subway = 1;
	else
		times_taken_subway = times_taken_subway + 1;
	end
	
	game:Set("num_times_taken_subway", times_taken_subway);
	
	setup_station();
	
	scene:SetFadeTarget { a = 0, r = 0, g = 0, b = 0 };
	scene:SetFadeColor { a = 1, r = 0, g = 0, b = 0 };
	scene:SetFadeSpeed(0.05);
	scene:SetMusicVolumeSpeed(0.05);
	--wait_fade();
	
	sfx:PlaySFX("audio/sfx/subway_arrive");
	if ( east ) then
		scene.TRAIN_EAST:PlayAnim( "Enter" );		
		wait_anim(scene.TRAIN_EAST);
	else
		scene.TRAIN_WEST:PlayAnim( "Enter" );
		wait_anim(scene.TRAIN_WEST);
	end
	
	if IsFirstPeek() then
		scene:DoPopup("", "pop_firstpeek_title", "pop_firstpeek_body");
		wait_subscene();
		scene:GameOver()
	end
end

function remove_token()
	if BAG_INV:CheckInventory("gold_token") == false then
		local token_count = game:Get("token_count");
		
		if token_count < 2 then
			token_count = 0;
			BAG_INV:RemoveInventory("token");
		else
			token_count = token_count - 1;
			BAG_INV:SetInventoryOvertext("token", tostring(token_count));
		end
		
		game:Set("token_count", token_count);
	end
end

function board_east(flo)
	flo:SetMode(MODE.CUTSCENE);
	remove_token();
	
	local progress = game:Get("module_progress");

	if progress < 3 then
		game:Set("last_module", progress);
		game:Set("cur_module", progress+1);
	else
		game:Set("subway_eastbound", 1);
		scene:ChainToSubScene("subwaymap");
		wait_subscene();
	end
	
	if game:Get("last_module") > 0 then
		if game:Get("last_module") ~= game:Get("cur_module") then
			sfx:PlaySFX("audio/sfx/token_turnstile");
			flo:WalkTo("turnstile_east_west");
			wait_walkto();
			scene.TURNSTILE_EAST:LoadImage( "turnstile_east_open" );
			delay(20);
			flo:WalkTo("turnstile_east_east");
			wait_walkto();
			scene.TURNSTILE_EAST:LoadImage( "turnstile_east_closed" );
			delay(20);
			
			flo:WalkTo("train_east");
			wait_walkto();
			
			sfx:PlaySFX("audio/sfx/subway_depart");
			scene.TRAIN_EAST:PlayAnim( "Open" );
			wait_anim(scene.TRAIN_EAST);
			scene.FLO:SetAlpha( 0 );
			scene.TRAIN_EAST:PlayAnim( "Close" );
			wait_anim(scene.TRAIN_EAST);
			
			train_fade(flo, true);

			scene.TRAIN_EAST:PlayAnim( "Open" );
			wait_anim(scene.TRAIN_EAST);
			scene.FLO:SetAlpha( 1 );
			scene.TRAIN_EAST:PlayAnim( "Close" );
			wait_anim(scene.TRAIN_EAST);

			flo:WalkTo("turnstile_east_east");
			wait_walkto();
			scene.TURNSTILE_EAST:LoadImage( "turnstile_east_open" );
			delay(20);
			flo:WalkTo("turnstile_east_west");
			wait_walkto();
			scene.TURNSTILE_EAST:LoadImage( "turnstile_east_closed" );
			delay(20);
		else
			if BAG_INV:CheckInventory("gold_token") == false then
				BAG_INV:AddInventory(inv_desc_token);
			end
		end
	end
	
	flo:WalkTo("flo");
	wait_walkto();
	
	if proceed_table.east ~= 1 then
		sfx:PlaySFX("audio/sfx/subway_depart");
		scene.TRAIN_EAST:PlayAnim( "Exit" );
		wait_anim(scene.TRAIN_EAST);
		scene.TRAIN_EAST:SetAlpha( 0 );
	end
	
	if proceed_table.west ~= 1 and scene.TRAIN_WEST then
		sfx:PlaySFX("audio/sfx/subway_depart");
		scene.TRAIN_WEST:PlayAnim( "Exit" );
		wait_anim(scene.TRAIN_WEST);
		scene.TRAIN_WEST:SetAlpha( 0 );
	end
	
	if do_map_tutorial then
		do_tutorial(game:Get("module_progress"));
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function check_gate_east(flo)
	flo:SetMode(MODE.CUTSCENE);
	if proceed_table.east == 1 then
		if proceed_table.cant_leave == 0 then
			if BAG_INV:CheckInventory("token") or BAG_INV:CheckInventory("gold_token") then
				run_super_conversation(flo, "quip_token");	
				flo:WalkTo("flo");
				wait_walkto();			
				flo:SetMode(MODE.FOLLOWCLICKS);
--				flo:StartProc(board_east);
			else
				run_super_conversation(flo, "quip_gate1_need_token");
				flo:WalkTo("flo");
				wait_walkto();
				
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		else
			run_super_conversation(flo, "quip_gate1_module_incomplete");
			flo:WalkTo("flo");
			wait_walkto();
			
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	else
		run_super_conversation(flo, "quip_no_train");
		flo:WalkTo("flo");
		wait_walkto();
		flo:Face(DIR.S);
		
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

function module_incomplete(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_gate1_module_incomplete");
	flo:WalkTo("flo");
	wait_walkto();
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function no_trains(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_no_train");
	flo:WalkTo("flo");
	wait_walkto();
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

gate_east_spec =
{
	name = "GATE_EAST";
	halo = "gate_east";
	gfx = { image = "south_east_gate" };
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, actor)
		flo:FaceActor(actor);
		
		--proceed_table.east = 1
		--proceed_table.cant_leave = 0
		
		flo:StartProc(check_gate_east);
	end;
	
	on_use_inv = function(item, flo, actor)
		if item == "token" or item == "gold_token" then
			if proceed_table.east == 1 and proceed_table.cant_leave == 0 then
				game:ClearInvUsage();
				flo:StartProc(board_east);
			elseif proceed_table.east == 0 then
				flo:StartProc(no_trains);
			else
				flo:StartProc(module_incomplete);
			end
			return RESPONSE_INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

function board_west(flo)
	flo:SetMode(MODE.CUTSCENE);
	remove_token();
	
	local progress = game:Get("module_progress");
	
	--if progress < 3 then
	--	game:Set("last_module", progress);
	--	game:Set("cur_module", progress+1)
	--else
		game:Set("subway_eastbound", 0);
		scene:ChainToSubScene("subwaymap");
		wait_subscene();
	--end
	
	if game:Get("last_module") > 0 then
		if game:Get("last_module") ~= game:Get("cur_module") then
			sfx:PlaySFX("audio/sfx/token_turnstile");
			flo:WalkTo("turnstile_west_east");
			wait_walkto();
			scene.TURNSTILE_WEST:LoadImage( "turnstile_west_open" );
			delay(20);
			flo:WalkTo("turnstile_west_west");
			wait_walkto();
			scene.TURNSTILE_WEST:LoadImage( "turnstile_west_closed" );	
			delay(20);			
		
			flo:WalkTo("train_west");
			wait_walkto();
			
			flo:Face(DIR.W);
			
			sfx:PlaySFX("audio/sfx/subway_depart");
			scene.TRAIN_WEST:PlayAnim( "Open" );
			wait_anim(scene.TRAIN_WEST);
			scene.FLO:SetAlpha( 0 );
			scene.TRAIN_WEST:PlayAnim( "Close" );
			wait_anim(scene.TRAIN_WEST);
			
			train_fade(flo, false);

			scene.TRAIN_WEST:PlayAnim( "Open" );
			wait_anim(scene.TRAIN_WEST);
			scene.FLO:SetAlpha( 1 );
			scene.TRAIN_WEST:PlayAnim( "Close" );
			wait_anim(scene.TRAIN_WEST);
			
			flo:WalkTo("turnstile_west_west");
			wait_walkto();
			scene.TURNSTILE_WEST:LoadImage( "turnstile_west_open" );
			delay(20);
			flo:WalkTo("turnstile_west_east");
			wait_walkto();
			scene.TURNSTILE_WEST:LoadImage( "turnstile_west_closed" );	
			delay(20);
		else
			if BAG_INV:CheckInventory("gold_token") == false then
				BAG_INV:AddInventory(inv_desc_token);
			end
		end
	end
	
	flo:WalkTo("flo");
	wait_walkto();
	
	if proceed_table.east ~= 1 and scene.TRAIN_EAST then	
		sfx:PlaySFX("audio/sfx/subway_depart");
		scene.TRAIN_EAST:PlayAnim( "Exit" );
		wait_anim(scene.TRAIN_EAST);
		scene.TRAIN_EAST:SetAlpha( 0 );
	end
	
	if proceed_table.west ~= 1 then
		sfx:PlaySFX("audio/sfx/subway_depart");
		scene.TRAIN_WEST:PlayAnim( "Exit" );
		wait_anim(scene.TRAIN_WEST);
		scene.TRAIN_WEST:SetAlpha( 0 );
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function check_gate_west(flo)
	flo:SetMode(MODE.CUTSCENE);
	if proceed_table.west == 1 then
		if proceed_table.cant_leave == 0 then
			if BAG_INV:CheckInventory("token") or BAG_INV:CheckInventory("gold_token") then
				run_super_conversation(flo, "quip_token");
				flo:WalkTo("flo");
				wait_walkto();			
				flo:SetMode(MODE.FOLLOWCLICKS);
				
--				flo:StartProc(board_west);
			else
				run_super_conversation(flo, "quip_gate1_need_token");
				flo:WalkTo("flo");
				wait_walkto();
				
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		else
			run_super_conversation(flo, "quip_gate1_module_incomplete");
			flo:WalkTo("flo");
			wait_walkto();
			
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	else
		run_super_conversation(flo, "quip_no_train");
		flo:WalkTo("flo");
		wait_walkto();
		flo:Face(DIR.S);
		
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

gate_west_spec =
{
	name = "GATE_WEST";
	halo = "gate_west";
	gfx = { image = "south_west_gate" };
	
	command = function(actor)
	end;
	
	on_arrive = function(flo, actor)
		flo:FaceActor(actor);
		--proceed_table.east = 1
		--proceed_table.cant_leave = 0
			
		flo:StartProc(check_gate_west);
	end;
	
	
	
	on_use_inv = function(item, flo, actor)
		if item == "token" or item == "gold_token" then
			if proceed_table.west == 1 and proceed_table.cant_leave == 0 then
				game:ClearInvUsage();
				flo:StartProc(board_west);
			elseif proceed_table.west == 0 then
				flo:StartProc(no_trains);
			else
				flo:StartProc(module_incomplete);
			end
			return RESPONSE_INV_HANDLED;		
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
}

train_east_anim_table =
{
	"anim/subway/subway_train2_enter", 
	"anim/subway/subway_train2_exit",
	"anim/subway/subway_train2_door",
};

train_east_spec =
{
	name = "TRAIN_EAST";
	halo = "train_east";
	anim = train_east_anim_table;
	--gfx = { image = "east_train" };	
	
	command = function(actor)
		actor:SetDepthValue(4);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Stopped");
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(function(flo)
			flo:SetMode(MODE.CUTSCENE);
			if proceed_table.cant_leave == 0 then
				run_super_conversation(flo, "quip_gate1_need_token");
			else
				run_super_conversation(flo, "quip_gate1_module_incomplete");
			end
				
			flo:SetMode(MODE.FOLLOWCLICKS);
		end);
	end;
	
	on_use_inv = function(item, flo, actor)
		return RESPONSE.INV_UNHANDLED;
	end;
}

train_west_anim_table =
{
	"anim/subway/subway_train1_enter", 
	"anim/subway/subway_train1_exit",
	"anim/subway/subway_train1_door",
};

train_west_spec =
{
	name = "TRAIN_WEST";
	halo = "train_west";
	anim = train_west_anim_table;
	--gfx = { image = "west_train" };
	
	command = function(actor)
		actor:SetDepthValue(4);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Stopped");
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(function(flo)
			flo:SetMode(MODE.CUTSCENE);
			if proceed_table.cant_leave == 0 then
				run_super_conversation(flo, "quip_gate1_need_token");
			else
				run_super_conversation(flo, "quip_gate1_module_incomplete");
			end
				
			flo:SetMode(MODE.FOLLOWCLICKS);
		end);
	end;
	
	on_use_inv = function(item, flo, actor)
		return RESPONSE.INV_UNHANDLED;
	end;
}

turnstile_east_spec =
{
	name = "TURNSTILE_EAST";
	gfx = { image = "turnstile_east_closed" };
	
	command = function(actor)
		actor:SetDepthValue(401);
	end;	
}

turnstile_west_spec =
{
	name = "TURNSTILE_WEST";	
	gfx = { image = "turnstile_west_closed" };
	
	command = function(actor)
		actor:SetDepthValue(401);
	end;	
}

function spawn_trains()
	if proceed_table.east == 1 and not scene.TRAIN_EAST then
		scene:Spawn(train_east_spec)
	end
	
	if proceed_table.west == 1 and not scene.TRAIN_WEST then
		scene:Spawn(train_west_spec);
	end
	
	if scene[subway1_spec.name] then
		scene[subway1_spec.name]:Expire();
	end
	
	if scene[subway2_spec.name] then
		scene[subway2_spec.name]:Expire();
	end
	--[[
	if scene[subway3_spec.name] then
		scene[subway3_spec.name]:Expire();
	end
	--]]
	local cur_module = game:Get("cur_module");
	if ( cur_module == 1 ) then
		if game:Get("module_progress") < 3 then
			scene:Spawn(subway1_spec);
		end
	elseif ( cur_module == 2 ) then
		scene:Spawn(subway2_spec);
	else
		--scene:Spawn(subway3_spec);
	end	
end

function setup_station()
	--Set current module and module progress
	set_module_progress();
	gate_check(proceed_table);
	
	--if scene.TRAIN_EAST then
	--	scene.TRAIN_EAST:Expire();
	--end
	
	--if scene.TRAIN_WEST then
	--	scene.TRAIN_WEST:Expire();
	--end
	
	if scene.SUBWAY1 then
		scene.SUBWAY1:Expire();
	end	
	
	if scene.SUBWAY2 then
		scene.SUBWAY2:Expire();
	end	
	
	--[[
	if scene.SUBWAY3 then
		scene.SUBWAY3:Expire();
	end
	--]]
	
	--while scene.TRAIN_EAST or scene.TRAIN_WEST do
	--	delay(1); -- time for stuff to Expire
	--end
	
	local cur_module = game:Get("cur_module");
	
	if cur_module == 3 then
		sfx:SetMusic("audio/music/music_streets3.ogg", true);
		game:SetString("map_position", "m3_subway");
		scene.MAP:LoadImage("subway_logo_bigcorp");
	elseif cur_module == 2 then
		sfx:SetMusic("audio/music/music_streets2.ogg", true);
		game:SetString("map_position", "m2_subway");
		scene.MAP:LoadImage("subway_logo_yumyum");
	else
		sfx:SetMusic("audio/music/walkingmusic.ogg", true);
		game:SetString("map_position", "m1_subway");
		scene.MAP:LoadImage("subway_logo_aveflo");
	end
	
	spawn_trains();
end

subway_sign_say_spec = 
{
	--font = "fonts/wiesbadenswing.mvec",
	lineheight = 20,
	color = { a = 1, r = 0, g = 0, b = 0 },
	outline_size = 0,
	bubble = false,
	anchor = ANCHOR.TOP,
	halign = HALIGN.LEFT,
	w = 100,
	h = 100,
	linepadding = -5
}

subway_sign_east_spec = 
{
	name = "SUBWAY_SIGN_EAST";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:ModifySaySpec(subway_sign_say_spec);
		actor:ModifySaySpec { x = 627, y = 50 };
		actor:SetAlpha(1);
		
		actor:Say("text_subway_east");
	end;
}

subway_sign_west_spec = 
{
	name = "SUBWAY_SIGN_WEST";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:ModifySaySpec(subway_sign_say_spec);
		actor:ModifySaySpec { halign = HALIGN.RIGHT, x = 75, y = 45 };
		actor:SetAlpha(1);
		
		actor:Say("text_subway_west");
	end;
}

litter_spec = 
{
	name = "LITTER";
	halo = "litter";
		
	on_arrive = function(flo, actor)
		flo:StartProc(talk_litter);			
	end;
}

function talk_litter(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_litter");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

payphone_spec = 
{
	name = "PAYPHONE";
	halo = "payphone";
		
	on_arrive = function(flo, actor)
		flo:StartProc(talk_payphone);	
	end;
}

function talk_payphone(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_payphone");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

change_machine_spec = 
{
	name = "CHANGE_MACHINE";
	halo = "change_machine";
		
	on_arrive = function(flo, actor)
		flo:StartProc(talk_change_machine);	
	end;
}

function talk_change_machine(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_change_machine");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

newspaper_spec = 
{
	name = "NEWSPAPER";
	halo = "newspaper";
		
	on_arrive = function(flo, actor)
		flo:StartProc(talk_newspaper);	
	end;
}

function talk_newspaper(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_newspaper");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

subway1_spec = 
{
	name = "BARB";
	halo = "quest/objects/barb";
	
	command = function(actor)
		prepare_actor_text(actor, barb_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
--		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:JumpToNamedPoint("subway1");
		actor:SetWalkSpeed(subway1_speed);
		actor:SetScale( 0.75 );
		
		actor:LoadAnimFile("anim/barb/stand");
		actor:FaceNow(DIR.S);
		actor:PlayAnim("DoStandS");
	end;
	
	on_arrive = function(flo, subway1)
		flo:StartProc(talk_to_subway1);
	end;
};

function talk_to_subway1(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.FLO:Face(DIR.W);
	scene.BARB:LoadAnimFile("anim/barb/stand_talk");
	scene.BARB:LoadAnimFile("anim/barb/talk");
	scene.BARB:DumpAnimFile("anim/barb/stand");
	
	scene.BARB:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BARB:PlayAnim( "ToTalkS" );
	wait_anim(scene.BARB);
	scene.BARB:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BARB:PlayAnim("DoStandS");
	
	conv_multiple(flo, "conv_subway1_", "A", 2);
	
	scene.BARB:DumpAnimFile("anim/barb/stand_talk");
	scene.BARB:DumpAnimFile("anim/barb/talk");
	scene.BARB:LoadAnimFile("anim/barb/stand");
	
	scene.FLO:Face(DIR.S);	

	scene.BARB:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BARB:PlayAnim( "ToStandS" );
	wait_anim(scene.BARB);
	scene.BARB:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BARB:PlayAnim("DoStandS");
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

subway2_spec = 
{
	name = "NORBERT";
	halo = "quest/objects/norbert_subway";
	gfx = { anim = "anim/norbert/subway" };
	
	command = function(actor)
		prepare_actor_text(actor, subway2_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		--actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("subway2");
		actor:SetWalkSpeed(subway2_speed);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:FaceNow(DIR.E);
	end;
	
	on_arrive = function(flo, subway2)
		flo:StartProc(talk_to_subway2);
	end;
};

function talk_to_subway2(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("subway2_talk") < 1 then
		run_super_conversation(flo, "conv_subway2_A");
	else
		run_super_conversation(flo, "conv_subway2_B")
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

subway3_anim_table = 
{
	"anim/subway3/stand",
	"anim/subway3/talkw",
};

subway3_spec = 
{
	name = "CHLOE";
	halo = "quest/objects/subway3";
	anim = subway3_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, subway3_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		--actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("subway3");
		actor:SetWalkSpeed(subway3_speed);
		actor:SetDepthValue( 2000 );
		actor:ModifySaySpec
		{
			bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEFLIP,
			bubble_mouth = { x = 50, y = 200 };
		};
	end;
	
	on_arrive = function(flo, subway3)
		flo:StartProc(talk_to_subway3);
	end;
};

function talk_to_subway3(flo)
	flo:SetMode(MODE.CUTSCENE);
	conv_multiple(flo, "conv_subway3_", "A", 2);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

tutorial_dialog_spec = 
{
	name = "TUTORIAL_DIALOG";
	gfx = { image = "quest/shared/tutorial_dialog_medium" };
	
	command = function(actor)
		actor:SetDepthValue(600);
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 };
			y = 315,
			x = 480,
			w = 275,
			h = 300,
			bubble = false,
			outline_size = 0,
			anchor = ANCHOR.TOP,
			halign = HALIGN.LEFT,
		};
	end;
}

tutorial_arrow_spec = 
{
	name = "TUTORIAL_ARROW";
	gfx = { image = "arrow_map" };
	
	command = function(actor)
		actor:SetDepthValue(600);
	end;
}

function do_tutorial(module_num)
	sfx:PlaySFX("audio/sfx/tutorial_popup.ogg");
	local dialog = scene:Spawn(tutorial_dialog_spec);
	local arrow = scene:Spawn(tutorial_arrow_spec);
	
	dialog:Say("text_module" .. module_num);
	coroutine.yield(RESUME.ON_CLICK);
	dialog:Expire();
	arrow:Expire();
	do_map_tutorial = false;
end

news_sign_spec = 
{
	name = "NEWS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(600);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 0, g = 0, b = 0 },
			outline_size = 0,
			lineheight = 30,
		}
		
		actor:SetAlpha(0.7);
		
		actor:Say("text_subway_news");
		actor:StopWalking();
		actor:SetPolygon({x=398,y=508}, {x=432,y=525}, {x=389,y=517}, {x=421,y=537});
		actor:TextToImage(6, 6);
	end;
}

change_sign_spec = 
{
	name = "CHANGE_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 0, g = 0, b = 0 },
			outline_size = 0,
			lineheight = 20,
		}
		
		actor:SetAlpha(0.7);
		
		actor:Say("text_subway_change");
		actor:StopWalking();
		actor:SetPolygon({x=600,y=153}, {x=630,y=174}, {x=600,y=163}, {x=630,y=183});
		actor:TextToImage(1, 1);
	end;
}

map_sign_spec = 
{
	name = "MAP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 0, g = 0, b = 0 },
			outline_size = 0,
			lineheight = 30,
		}
		
		actor:SetAlpha(0.7);
		
		actor:Say("text_subway_map");
		actor:StopWalking();
		actor:SetPolygon({x=407,y=254}, {x=444,y=242}, {x=406,y=268}, {x=444,y=255});
		actor:TextToImage(20, 1);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		delay(1);
		if game:Get("goto_module") == 2 then
			game:Set("goto_module", 0);
			scene:ChainTo("m2_sizzle1");
		elseif game:Get("goto_module") == 3 then
			game:Set("goto_module", 0);
			scene:ChainTo("m3_pancake");
		end
	
		--sfx:SetMusic("audio/music/walkingmusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.8, 1.0);	--topline, bottomline, topscale, bottomscale
		game:Set("got_napkin", 1);
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_gold_token);
			--complete_quest("wedding_dress", false);
			--complete_quest("find_snookums", false);
			--complete_quest("cake", false)
			--complete_quest("collect_butterflies1", false)
			--complete_quest("collect_butterflies2", false)
			--complete_quest("flowers", false)
			--do_tutorial(3);
		end
		
		local lastScene = game:GetLastScene();

		if lastScene ~= "goto_module2" and lastScene ~= "goto_module3" then		
			local cur_module = 0;
			
			if lastScene == "m3_pancake" then
				cur_module = 3;
			elseif lastScene == "m2_sizzle1" then
				cur_module = 2;
				game:Set("subway2_talk", 1);
			else
				cur_module = 1;
			end
			
			game:Set("cur_module", cur_module);
		end
		
		setup_station();
		
		scene:Spawn(flo_spec);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "tunnel_east", 1 },
		{ "tunnel_west", 2 },
		
		{ "background", 5 },
		
		{ "east_gate", 400 },
		{ "west_gate", 400 },
		
		{ "map", 390},
		
		{ "bench", 599 },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		exit_spec,
		map_spec,
		gate_east_spec,
		gate_west_spec,
		subway_sign_east_spec,
		subway_sign_west_spec,
		turnstile_east_spec,
		turnstile_west_spec,
		litter_spec,
		payphone_spec,
		change_machine_spec,
		newspaper_spec,
		news_sign_spec,
		change_sign_spec,
		map_sign_spec,
		
		scene_setup,
	};
};
